module net.BurtonRadons.dig.platform.label;

private import net.BurtonRadons.dig.platform.base;
private import net.BurtonRadons.dig.platform.control;
private import net.BurtonRadons.dig.platform.font;
private import net.BurtonRadons.dig.platform.windows;
//private import std.utf;

/** This widget shows a line of text.
  * Until explicitly given, the size of this widget depends upon
  * the length and height of the text within it.
  */

class Label : Control
{
    /** Register with the parent and create the widget. */
    this (Control parent)
    {
        super (parent);
        digPlatformStyle |= std.c.windows.windows.WS_VISIBLE | std.c.windows.windows.WS_CHILD | std.c.windows.windows.SS_NOTIFY | std.c.windows.windows.SS_LEFTNOWORDWRAP;
        digPlatformHWNDCreate (0, "Static", null, digPlatformStyle, (_HANDLE) 0);
    }

    /** Set the text caption.  This can modify the width and height. */
    void caption (char [] text)
    {
        digPlatformSetCaption (text);
        recalculate ();
    }

    /** Change the font; passing null has no effect. */
    void font (Font font)
    {
        if (font === null)
            return;
        SendMessageA (digPlatformHWND, WM_SETFONT, (_DWORD) font.digPlatformGetHFONT (), 1);
        recalculate ();
    }

    /** Get the font. */
    Font font ()
    {
        _HGDIOBJ font;

        font = (_HANDLE) SendMessageA (digPlatformHWND, WM_GETFONT, 0, 0);
        return new Font (font);
    }

    /** Set the text to left align within its width or center if false. */
    void alignLeft (bit value) { digPlatformSetStyle (SS_LEFT, value); }

    /** Set the text to right align within its width or center if false. */
    void alignRight (bit value) { digPlatformSetStyle (SS_RIGHT, value); }

    /** Set whether this is active (true) or grayed and inactive (false). */
    void enabled (bit value)
    {
        EnableWindow (digPlatformHWND, value);
    }

    /* Recalculate the size */
    override void recalculate ()
    {
        _HGDIOBJ font;
        _DWORD result;
        
        font = (_HANDLE) SendMessageA (digPlatformHWND, WM_GETFONT, 0, 0);
        SelectObject (digPlatformHDC, font);
        result = GetTabbedTextExtentW (digPlatformHDC, digPlatformCaption, digPlatformCaption.length, 0, null);
        digPlatformSuggestWidth = (result & 0xFFFF) + 6;
        digPlatformSuggestHeight = (result >> 16) + 6;
        digPlatformMoved ();
    }
}

